/*
   OfZ@p32rbgDIBNX

        2005/ 4/11 ˁ@P
*/

#include <windows.h>
#include "classes.h"

// m
LPVOID MALLOC(int iSize) {

	if (iSize < 1) {
		return NULL;
	}

	return HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, iSize);

}

// 
bool FREE(LPVOID lpBuf) {

	if (lpBuf == NULL) {
		return true;
	}

	HeapFree(GetProcessHeap(), 0, lpBuf);

	return true;

}

CBitmap32::CBitmap32() {

	m_iWidth = 0;
	m_iHeight = 0;

	m_lpBuf = NULL;
	m_lpbmiInfo = NULL;
	m_lpPixels = NULL;

	init(128, 128);

}

CBitmap32::CBitmap32(int iWidth, int iHeight) {

	m_iWidth = 0;
	m_iHeight = 0;

	m_lpBuf = NULL;
	m_lpbmiInfo = NULL;
	m_lpPixels = NULL;

	init(iWidth, iHeight);

}

CBitmap32::CBitmap32(LPCTSTR lpszFilePath) {

	m_lpPixels = NULL;

	loadImage(lpszFilePath);

}

bool CBitmap32::assign(const CBitmap32 *pbmArg) {

	if (pbmArg == this) {
		return true;
	}

	if (pbmArg == NULL) {
		return false;
	}

	if (!init(pbmArg->getWidth(), pbmArg->getHeight())) {
		return false;
	}

	CopyMemory(m_lpPixels, pbmArg->m_lpPixels, m_iWidth * m_iHeight * 4);

	return true;

}

CBitmap32& CBitmap32::operator=(const CBitmap32& bmp) {

	if (this != &bmp) {
		assign(&bmp);
	}

	return *this;

}

// wTCYŃNA
bool CBitmap32::init(int iWidth, int iHeight) {

	if (iWidth * iHeight < 1) {
		return false;
	}

	FREE(m_lpBuf);

	m_iWidth = iWidth;
	m_iHeight = iHeight;

	// rbg}bvpm
	m_lpBuf = (LPDWORD)MALLOC(sizeof(BITMAPINFOHEADER) + m_iWidth * m_iHeight * 4);

	if (m_lpBuf == NULL) {

		m_iWidth = 0;
		m_iHeight = 0;

		return false;

	}

	// mۂBITMAPINFOƃsNZ̃|C^ݒ
	m_lpbmiInfo = (LPBITMAPINFOHEADER)m_lpBuf;
	m_lpPixels = (LPDWORD)(m_lpbmiInfo + 1);

	// BITMAPINFOݒ
	m_lpbmiInfo->biSize = sizeof(BITMAPINFOHEADER);
	m_lpbmiInfo->biWidth = m_iWidth;
	m_lpbmiInfo->biHeight = -m_iHeight;
	m_lpbmiInfo->biPlanes = 1;
	m_lpbmiInfo->biBitCount = 32;

	return true;

}

bool CBitmap32::loadImage(LPCTSTR lpszFilePath) {

	if (lpszFilePath == NULL) {
		return false;
	}

	DWORD dwOffset, dwRead;
	LPBYTE lpBuf, lpPix;
	LPBITMAPINFO lpWrkBM;

	HANDLE fh;
	int iWidth, iHeight, iLineSize;

	/* BMPJ */
	fh = CreateFile(lpszFilePath, GENERIC_READ, 0, NULL, OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL, NULL);

	if (fh == INVALID_HANDLE_VALUE) {
		return false;
	}

	if (GetFileSize(fh, NULL) < 14) {

		CloseHandle(fh);

		return false;

	}

	/* BMPǂݍݗpobt@m */
	lpBuf = (LPBYTE)MALLOC(GetFileSize(fh, NULL));

	/* BMPǂݍ */
	ReadFile(fh, lpBuf, GetFileSize(fh, NULL), &dwRead, NULL);

	/* BMP */
	CloseHandle(fh);

	/* BITMAPINFO擾 */
	lpWrkBM = (LPBITMAPINFO)(lpBuf + sizeof(BITMAPFILEHEADER));

	/* sNZ܂ł̃ItZbg擾 */
	dwOffset = *(LPDWORD)(lpBuf + 10);

	iWidth = lpWrkBM->bmiHeader.biWidth;
	iHeight = lpWrkBM->bmiHeader.biHeight;

	iLineSize = iWidth * 3;

	if (iLineSize % 4 != 0) {
		iLineSize +=  4- (iLineSize % 4);
	}

	if (lpWrkBM->bmiHeader.biBitCount != 24 ||
	    dwRead < dwOffset + iLineSize * iHeight) {

		FREE(lpBuf);

		return false;

	}

	/* sNZ̐擪AhX */
	lpPix = lpBuf + dwOffset;

	if (!init(iWidth, iHeight)) {

		FREE(lpBuf);

		return false;

	}

	/* 24-32rbgϊsȂsNZݒ */
	for (int i = 0;i < m_iHeight;i++) {
		for (int j = 0;j < m_iWidth;j++) {

			setR(j, m_iHeight - i - 1, lpPix[j * 3 + i * iLineSize + 2]);
			setG(j, m_iHeight - i - 1, lpPix[j * 3 + i * iLineSize + 1]);
			setB(j, m_iHeight - i - 1, lpPix[j * 3 + i * iLineSize]);

		}
	}

	/* BMPǂݍ݃obt@ */
	FREE(lpBuf);

	return true;

}

bool CBitmap32::loadImage(const LPVOID lpImage) {

	if (lpImage == NULL) {
		return false;
	}

	const LPBYTE lpBuf = (LPBYTE)lpImage;
	LPBYTE lpPix;
	DWORD dwOffset;
	LPBITMAPINFO lpWrkBM;

	int iWidth, iHeight, iLineSize;

	/* BITMAPINFO擾 */
	lpWrkBM = (LPBITMAPINFO)((LPBYTE)lpImage + sizeof(BITMAPFILEHEADER));

	/* sNZ܂ł̃ItZbg擾 */
	dwOffset = *(LPDWORD)(lpBuf + 10);

	iWidth = lpWrkBM->bmiHeader.biWidth;
	iHeight = lpWrkBM->bmiHeader.biHeight;

	iLineSize = iWidth * 3;

	if (iLineSize % 4 != 0) {
		iLineSize +=  4- (iLineSize % 4);
	}

	if (lpWrkBM->bmiHeader.biBitCount != 24) {
		return false;
	}

	/* sNZ̐擪AhX */
	lpPix = lpBuf + dwOffset;

	if (!init(iWidth, iHeight)) {
		return false;
	}

	/* 24-32rbgϊsȂsNZݒ */
	for (int i = 0;i < m_iHeight;i++) {
		for (int j = 0;j < m_iWidth;j++) {

			setR(j, iHeight - i - 1, lpPix[j * 3 + i * iLineSize + 2]);
			setG(j, iHeight - i - 1, lpPix[j * 3 + i * iLineSize + 1]);
			setB(j, iHeight - i - 1, lpPix[j * 3 + i * iLineSize]);

		}
	}

	return true;

}

bool CBitmap32::saveImage(LPCTSTR lpszFilePath) {

	DWORD dwSize;
	int iFileSize, iLength;
	HANDLE fh;
	LPBITMAPFILEHEADER lpHead;
	LPBITMAPINFOHEADER lpInfo;
	LPBYTE lpBuf, lpPixel;

	if (m_iWidth % 4 == 0) { // obt@̂PC̒vZ
		iLength = m_iWidth * 3;
	} else {
		iLength = m_iWidth * 3 + (4 - (m_iWidth * 3) % 4);
	}

	// ݗpobt@̃TCYvZ
	iFileSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + iLength * m_iHeight;

	// obt@mۂƃ|C^ݒ
	lpBuf = (LPBYTE)MALLOC(iFileSize);
	lpHead = (LPBITMAPFILEHEADER)lpBuf;
	lpInfo = (LPBITMAPINFOHEADER)(lpBuf + sizeof(BITMAPFILEHEADER));
	lpPixel = lpBuf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	// 24rbgBMPt@C̃wb_쐬
	lpHead->bfType = 'M'*256+'B';
	lpHead->bfSize = iFileSize;
	lpHead->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	lpInfo->biSize = sizeof(BITMAPINFOHEADER);
	lpInfo->biWidth = m_iWidth;
	lpInfo->biHeight = m_iHeight;
	lpInfo->biPlanes = 1;
	lpInfo->biBitCount = 24;

	for (int i = 0;i < m_iHeight;i++) // sNZobt@ɃRs[
		for (int j = 0;j < m_iWidth;j++)
			CopyMemory(lpPixel + i * iLength + j * 3, 
			           m_lpPixels + (m_iHeight - i - 1) * m_iWidth + j, 3);

	// obt@t@Cɏo
	fh = CreateFile(lpszFilePath, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

	WriteFile(fh, lpBuf, iFileSize, &dwSize, NULL);

	CloseHandle(fh);
	GlobalFree(lpBuf);

	if ((int)dwSize < iFileSize) {
		return false;
	}

	return true;

}

// Nbv{[hrbg}bv擾
bool CBitmap32::paste() {

	if (!OpenClipboard(NULL)) {
		return false;
	}

	HANDLE hMem = GetClipboardData(CF_DIB);

	if (hMem == NULL || GlobalSize(hMem) < sizeof(BITMAPINFOHEADER)) {

		CloseClipboard();

		return false;

	}

	LPBYTE lpBuf = (LPBYTE)GlobalLock(hMem);
	LPBITMAPINFOHEADER lpBM = (LPBITMAPINFOHEADER)lpBuf;

	// 24/32rbgDIBłȂ΁A߂
	if (lpBM->biBitCount != 24 && lpBM->biBitCount != 32) {

		GlobalUnlock(hMem);
		CloseClipboard();

		return false;

	}

	LPBYTE lpBMP = lpBuf + lpBM->biSize;
	
	int iWidth = lpBM->biWidth, iHeight = lpBM->biHeight;
	int iLength;

	if ((iWidth) % 4==0) { // obt@̂PC̒vZ
		iLength=iWidth * 3;
	} else {
		iLength = iWidth * 3 + (4 - (iWidth * 3) % 4);
	}

	if (lpBM->biBitCount == 24 && GlobalSize(hMem) < iLength * iHeight + lpBM->biSize) {

		GlobalUnlock(hMem);

		CloseClipboard();

		return false;

	}

	if (lpBM->biBitCount == 32 && GlobalSize(hMem) < iWidth * iHeight * 4 + lpBM->biSize) {

		GlobalUnlock(hMem);

		CloseClipboard();

		return false;

	}

	if (!init(iWidth, iHeight)) {

		GlobalUnlock(hMem);

		CloseClipboard();

		return false;

	}

	if (lpBM->biBitCount == 24) {
		for (int i = 0;i < iHeight;i++) // sNZobt@ɃRs[
			for (int j = 0;j < iWidth;j++)
				CopyMemory(m_lpPixels + (m_iHeight - i - 1) * iWidth + j, lpBMP + i * iLength + j * 3, 3);
	} else {
		for (int i = 0;i < iHeight;i++) // sNZobt@ɃRs[
			CopyMemory(m_lpPixels + (m_iHeight - i - 1) * iWidth, lpBMP + i * iWidth * 4, m_iWidth * 4);
	}

	GlobalUnlock(hMem);
	CloseClipboard();

	return true;

}

// Nbv{[hփrbg}bvRs[
bool CBitmap32::copy() {

	int iLength;
	LPBITMAPINFOHEADER lpInfo;
	LPBYTE lpPixel;
	HGLOBAL hMem;
	LPBYTE lpMem;

	if (m_iWidth % 4 == 0) { // obt@̂PC̒vZ
		iLength = m_iWidth * 3;
	} else {
		iLength = m_iWidth * 3 + (4 - (m_iWidth * 3) % 4);
	}

	// obt@p̃ubNm
	hMem = GlobalAlloc(GHND, sizeof(BITMAPINFOHEADER) + iLength * m_iHeight);

	// IuWFNgbNăAhX擾
	lpMem = (LPBYTE)GlobalLock(hMem);

	lpInfo = (LPBITMAPINFOHEADER)lpMem;
	lpPixel = lpMem + sizeof(BITMAPINFOHEADER);
	ZeroMemory(lpInfo, sizeof(BITMAPINFOHEADER));

	// 24rbgDIBwb_쐬
	lpInfo->biSize=sizeof(BITMAPINFOHEADER);
	lpInfo->biWidth = m_iWidth;
	lpInfo->biHeight = m_iHeight;
	lpInfo->biPlanes = 1;
	lpInfo->biBitCount = 24;

	for (int i = 0;i < m_iHeight;i++) // sNZobt@ɃRs[
		for (int j = 0;j < m_iWidth;j++)
			CopyMemory(lpPixel + (m_iHeight - i - 1) * iLength + j * 3, m_lpPixels + i * m_iWidth + j, 3);

	// obt@AbN
	GlobalUnlock(hMem);

	// Nbv{[hI[vNA
	OpenClipboard(NULL);
	EmptyClipboard();

	// Nbv{[hɃobt@̓eRs[
	SetClipboardData(CF_DIB, hMem);

	// Nbv{[hN[Y
	CloseClipboard();

	return true;

}

int CBitmap32::getWidth() const { return m_iWidth; }
int CBitmap32::getHeight() const { return m_iHeight; }

LPBITMAPINFO CBitmap32::getInfo() const { return (LPBITMAPINFO)m_lpbmiInfo; }
LPVOID CBitmap32::getPixels() const { return m_lpPixels; }

BYTE CBitmap32::getR(int iX, int iY) const {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return 0;
	}

	return (BYTE)((0x00ff0000 & m_lpPixels[iX + iY * m_iWidth]) >> 16);

}

BYTE CBitmap32::getG(int iX, int iY) const {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return 0;
	}

	return (BYTE)((0x0000ff00 & m_lpPixels[iX + iY * m_iWidth]) >> 8);

}

BYTE CBitmap32::getB(int iX, int iY) const {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return 0;
	}

	return (BYTE)(0x000000ff & m_lpPixels[iX + iY * m_iWidth]);

}

DWORD CBitmap32::getRGB(int iX, int iY) const {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return 0;
	}

	return 0x00ffffff & m_lpPixels[iX + iY * m_iWidth];

}

DWORD CBitmap32::getPixel(int iX, int iY) const {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return 0;
	}

	return m_lpPixels[iX + iY * m_iWidth];

}

bool CBitmap32::setR(int iX, int iY, int iValue) {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return false;
	}

	if (iValue < 0) {
		iValue = 0;
	}

	if (iValue > 255) {
		iValue = 255;
	}

	((LPBYTE)m_lpPixels)[iX * 4 + iY * m_iWidth * 4 + 2] = (BYTE)iValue;

	return true;

}

bool CBitmap32::setG(int iX, int iY, int iValue) {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return false;
	}

	if (iValue < 0) {
		iValue = 0;
	}

	if (iValue > 255) {
		iValue = 255;
	}

	((LPBYTE)m_lpPixels)[iX * 4 + iY * m_iWidth * 4 + 1] = (BYTE)iValue;

	return true;

}

bool CBitmap32::setB(int iX, int iY, int iValue) {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return false;
	}

	if (iValue < 0) {
		iValue = 0;
	}

	if (iValue < 0) {
		iValue = 0;
	}

	if (iValue > 255) {
		iValue = 255;
	}

	((LPBYTE)m_lpPixels)[iX * 4 + iY * m_iWidth * 4] = (BYTE)iValue;

	return true;

}

bool CBitmap32::setRGB(int iX, int iY, DWORD dwValue) {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return false;
	}

	m_lpPixels[iX + iY * m_iWidth] = 0x00ffffff & dwValue;

	return true;

}

bool CBitmap32::addRGB(int iX, int iY, int iDR, int iDG, int iDB) {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return false;
	}

	setR(iX, iY, getR(iX, iY) + iDR);
	setG(iX, iY, getG(iX, iY) + iDG);
	setB(iX, iY, getB(iX, iY) + iDB);

	return true;

}

bool CBitmap32::setPixel(int iX, int iY, DWORD dwValue) {

	if (iX < 0 || iX >= m_iWidth || iY < 0 || iY >= m_iHeight) {
		return false;
	}

	m_lpPixels[iX + iY * m_iWidth] = dwValue;

	return true;

}

CBitmap32::~CBitmap32() {

	FREE(m_lpBuf);

}
