//
//    OfZ@ 05
//
//  2006/ 5/25 ˁ@P
//
#include "classes.h"
#include <math.h>
#include <commctrl.h>
#pragma comment(lib, "comctl32.lib")

HINSTANCE hInst;

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK BMPWndProc(HWND, UINT, WPARAM, LPARAM);

HWND hwMain, hwBMP, hwState;
HMENU hMenu, hMenuFile, hMenuInfo, hMenuEdit, hMenuHelp;

DWORD dwWidth, dwHeight, dwVWidth, dwVHeight, dwVSizeW, dwVSizeH;
bool fSave = FALSE; 
TCHAR lpszAppName[] = "OfZ@";
TCHAR lpszFileName[MAX_PATH + 1], lpszTitle[MAX_PATH + 32];
int iDR, iDG, iDB, iSize;

#define IDM_OPEN    101
#define IDM_SAVE    102
#define IDM_WRITE   103
#define IDM_EXIT    104
#define IDM_COPY    202
#define IDM_PASTE   203
#define IDM_ALL     204
#define IDM_SIZE    301
#define IDM_ABOUT   801
#define IDM_JUMP    802

#define BMP_WND_YPOS 32

CBitmap32 bmBMP;

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow){

	MSG  msg;
	WNDCLASSEX wndclass;

	hInst = hInstance; // vZX̃nhۑ

	InitCommonControls();

	// EChENXݒ
	wndclass.cbSize        = sizeof(wndclass);
	wndclass.style         = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc   = WndProc;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = hInstance;
	wndclass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
	wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = "CWindow";
	wndclass.hIconSm       = LoadIcon(NULL, IDI_APPLICATION);

	RegisterClassEx(&wndclass); // EChENXo^

	lpszFileName[0] = 0;

	if (lstrcmpi(szCmdLine, "") != 0) {

		/* t@C̑O""΍폜 */
		if (szCmdLine[0] == '"') {
			wsprintf(szCmdLine, "%s", szCmdLine+1);
		}

		if (szCmdLine[lstrlen(szCmdLine) - 1] == '"') {
			szCmdLine[lstrlen(szCmdLine) - 1] = 0;
		}

		if (bmBMP.loadImage(szCmdLine)) {
			lstrcpy(lpszFileName, szCmdLine);
		}

	}

	dwVSizeW = bmBMP.getWidth();
	dwVSizeH = bmBMP.getHeight();

	iDR = 0;
	iDG = 0;
	iDB = 0;
	iSize = 1;

	hwMain = CreateWindow("CWindow", lpszAppName,
	  WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT,
	  600, 450, NULL, NULL, hInstance, NULL);

	if (lpszFileName[0] != 0) { // 摜t@Cǂݍ܂Ă

		wsprintf(lpszTitle, "%s - %s", lpszAppName, lpszFileName);
		SetWindowText(hwMain, lpszTitle);

	}

	// j[쐬
	hMenu = CreateMenu();      // gbvx
	hMenuFile = CreateMenu();  // ut@Cvj[
	hMenuEdit = CreateMenu();  // uҏWvj[
	hMenuInfo = CreateMenu();  // u摜vj[
	hMenuHelp = CreateMenu();  // uwvvj[

    // ut@Cvj[ڍ쐬
	AppendMenu(hMenuFile, MF_STRING,IDM_OPEN, "Ji&Oj");
	AppendMenu(hMenuFile, MF_STRING,IDM_SAVE, "ۑi&Aj");
	AppendMenu(hMenuFile, MF_STRING,IDM_WRITE, "㏑ۑi&Sj");
	AppendMenu(hMenuFile, MF_SEPARATOR, 0, NULL);
	AppendMenu(hMenuFile, MF_STRING,IDM_EXIT, "Ii&Xj");

	// uҏWvj[ڍ쐬
	AppendMenu(hMenuEdit, MF_STRING, IDM_COPY, "rbg}bvRs[(&C)");
	AppendMenu(hMenuEdit, MF_STRING, IDM_PASTE, "rbg}bv\t(&P)");
	AppendMenu(hMenuEdit, MF_STRING, IDM_ALL, "S̏(&A)");

	// u摜vj[ڍ쐬
	AppendMenu(hMenuInfo, MF_STRING, IDM_SIZE, "摜TCY(&S)");

	// wvj[ڍ쐬
	AppendMenu(hMenuHelp, MF_STRING, IDM_ABOUT, "o[Wi&Aj");
	AppendMenu(hMenuHelp, MF_STRING, IDM_JUMP, "҃TCgunvO~O̊Xvցi&Gj");

	// gbvxj[ɒǉ
	AppendMenu(hMenu, MF_POPUP, (UINT)hMenuFile, "t@Ci&Fj");
	AppendMenu(hMenu, MF_POPUP, (UINT)hMenuEdit, "ҏWi&Ej");
	AppendMenu(hMenu, MF_POPUP, (UINT)hMenuInfo, "摜i&Ij");
	AppendMenu(hMenu, MF_POPUP, (UINT)hMenuHelp, "wvi&Hj");

	// EChEɃj[ݒ
	SetMenu(hwMain, hMenu);

	while (GetMessage(&msg, NULL, 0, 0)) { /* bZ[W[v */

		TranslateMessage(&msg);
		DispatchMessage(&msg);

	}

	return (int)msg.wParam;

}

// CEChEEChEvV[W|
LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam) {

	static OPENFILENAME ofn;
	static char lpszFn[256], lpszFt[256], lpszWrk[256];
	static PCHAR lpszOpen = "J", lpszSave = "ۑ";
	HDROP hDrop;
	static WNDCLASSEX wndclass;
	static int iVSize;
	RECT rec;
	static HWND hwEditR, hwUdR, hwEditG, hwUdG, hwEditB, hwUdB, hwEditSize,hwUdSize;
	char aszTmp[256];

	int i, j;

	switch (iMsg) {

	case WM_CREATE:

		// OPENFILENAME\̏
		ofn.lStructSize = sizeof(OPENFILENAME);
		ofn.hwndOwner = hwMain;
		ofn.hInstance = hInst;
		ofn.lpstrFilter = "rbg}bv(*.bmp)\0*.bmp\0ׂẴt@C(*.*)\0*.*\0\0";
		ofn.lpstrCustomFilter = NULL;
		ofn.nMaxCustFilter = 0;
		ofn.nFilterIndex = 1;
		ofn.lpstrFile = lpszFn;
		ofn.nMaxFile = 255;
		ofn.lpstrFileTitle = lpszFt;
		ofn.nMaxFileTitle = 255;
		ofn.lpstrInitialDir = NULL;
		ofn.lpstrTitle = NULL;
		ofn.Flags = 0;
		ofn.nFileOffset = 0;
		ofn.nFileExtension = 0;
		ofn.lpstrDefExt = NULL;
		ofn.lCustData = 0;
		ofn.lpfnHook = NULL;
		ofn.lpTemplateName = NULL;

		DragAcceptFiles(hwnd, TRUE); // hbOhbv

		CreateWindow("STATIC", "R", WS_CHILD | WS_VISIBLE | SS_CENTER,
          4, 5, 22, 20, hwnd, (HMENU)0, hInst, NULL);
		hwEditR = CreateWindow("Edit", NULL,WS_CHILD | WS_VISIBLE | WS_BORDER | WS_TABSTOP | ES_READONLY,
		  28, 4, 48, 22, hwnd, (HMENU)1, hInst, NULL);
		hwUdR = CreateUpDownControl(WS_CHILD | WS_BORDER | WS_VISIBLE | UDS_SETBUDDYINT,
		  76, 4, 24, 22, hwnd, 2, hInst, hwEditR, 256, -256, 0);

		CreateWindow("STATIC", "G", WS_CHILD | WS_VISIBLE | SS_CENTER,
          108, 5, 22, 20, hwnd, (HMENU)0, hInst, NULL);
		hwEditG = CreateWindow("Edit", NULL,WS_CHILD | WS_VISIBLE | WS_BORDER | ES_READONLY,
		  132, 4, 48, 22, hwnd, (HMENU)1, hInst, NULL);
		hwUdG = CreateUpDownControl(WS_CHILD | WS_BORDER | WS_VISIBLE | UDS_SETBUDDYINT,
		  180, 4, 24, 22, hwnd, 2, hInst, hwEditG, 256, -256, 0);

		CreateWindow("STATIC", "B", WS_CHILD | WS_VISIBLE | SS_CENTER,
          212, 5, 22, 20, hwnd, (HMENU)0, hInst, NULL);
		hwEditB = CreateWindow("Edit", NULL,WS_CHILD | WS_VISIBLE | WS_BORDER | ES_READONLY,
		  234, 4, 48, 22, hwnd, (HMENU)1, hInst, NULL);
		hwUdB = CreateUpDownControl(WS_CHILD | WS_BORDER | WS_VISIBLE | UDS_SETBUDDYINT,
		  282, 4, 24, 22, hwnd, 2, hInst, hwEditB, 256, -256, 0);

		CreateWindow("STATIC", "yTCY", WS_CHILD | WS_VISIBLE | SS_CENTER,
          320, 5, 122, 20, hwnd, (HMENU)0, hInst, NULL);
		hwEditSize = CreateWindow("Edit", NULL,WS_CHILD | WS_VISIBLE | WS_BORDER | WS_TABSTOP | ES_READONLY,
		  442, 4, 48, 22, hwnd, (HMENU)1, hInst, NULL);
		hwUdSize = CreateUpDownControl(WS_CHILD | WS_BORDER | WS_VISIBLE | UDS_SETBUDDYINT,
		  490, 4, 24, 22, hwnd, 2, hInst, hwEditSize, 16, 1, 1);

		wndclass.cbSize        = sizeof(wndclass);
		wndclass.style         = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc   = BMPWndProc;
		wndclass.cbClsExtra    = 0;
		wndclass.cbWndExtra    = 0;
		wndclass.hInstance     = hInst;
		wndclass.hIcon         = NULL;
		wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground = (HBRUSH)GetStockObject(GRAY_BRUSH);
		wndclass.lpszMenuName  = NULL;
		wndclass.lpszClassName = "CBMPWin";
		wndclass.hIconSm       = NULL;

		RegisterClassEx(&wndclass); // rbg}bvEChENXo^

		hwBMP = CreateWindow("CBMPWin",NULL,
		         WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL,
		         0, 0, 1, 1, hwnd, NULL, hInst, NULL);

		// Xe[^Xo[쐬
		hwState = CreateStatusWindow(WS_CHILD | WS_VISIBLE, NULL, hwnd, 0);

		return 0;

	case WM_VSCROLL: // Abv_ERg[ύX

		if (lParam == (LPARAM)hwUdR) {

			GetWindowText(hwEditR, aszTmp, 16);
			iDR = atol(aszTmp);

		}

		if (lParam == (LPARAM)hwUdG) {

			GetWindowText(hwEditG, aszTmp, 16);
			iDG = atol(aszTmp);

		}

		if (lParam == (LPARAM)hwUdB) {

			GetWindowText(hwEditB, aszTmp, 16);
			iDB = atol(aszTmp);

		}

		if (lParam == (LPARAM)hwUdSize) {

			GetWindowText(hwEditSize, aszTmp, 16);
			iSize = atol(aszTmp);

		}

		return 0;

	case WM_DROPFILES: // t@Chbv

		hDrop = (HDROP)wParam;

		// hbvꂽt@C擾
		DragQueryFile(hDrop, 0, lpszWrk, 256);

		if (bmBMP.loadImage(lpszWrk)) { // t@Cǂݍ

			fSave = false;

			lstrcpy(lpszFileName, lpszWrk);
			lstrcpy(lpszFn, lpszWrk);

			wsprintf(lpszTitle, "%s - %s", lpszAppName, lpszFileName);
			SetWindowText(hwMain, lpszTitle);

		}

		DragFinish(hDrop);

		dwVSizeW = bmBMP.getWidth();
		dwVSizeH = bmBMP.getHeight();
		MoveWindow(hwBMP, 0, BMP_WND_YPOS, dwVWidth - 1, dwVHeight - 1, FALSE);
		MoveWindow(hwBMP, 0, BMP_WND_YPOS, dwVWidth, dwVHeight, TRUE);

		InvalidateRgn(hwnd, NULL, FALSE);
		UpdateWindow (hwnd);

		break;

	case WM_INITMENUPOPUP: // Cj[ݒ

		// ㏑j[
		if (lParam == 0 && fSave) {
			EnableMenuItem((HMENU)wParam, IDM_WRITE, MF_ENABLED);
		} else {
			EnableMenuItem((HMENU)wParam, IDM_WRITE, MF_GRAYED);
		}

		// \tj[
		if (lParam == 1 && IsClipboardFormatAvailable(CF_DIB)) {
			EnableMenuItem((HMENU)wParam, IDM_PASTE, MF_ENABLED);
		} else {
			EnableMenuItem((HMENU)wParam, IDM_PASTE, MF_GRAYED);
		}

		break;

	case WM_COMMAND:

		switch (LOWORD(wParam)) {

		case IDM_OPEN: // Jj[

			// _CAOݒ
			ofn.lpstrTitle = lpszOpen;
			ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
			ofn.nFilterIndex = 1;

			if (!GetOpenFileName(&ofn)) { // t@CI
				return 0;
			}

			if (bmBMP.loadImage(lpszFn)) { // t@Cǂݍ

				fSave = false;

				lstrcpy(lpszFileName, lpszFn);
				wsprintf(lpszTitle, "%s - %s", lpszAppName, lpszFileName);
				SetWindowText(hwMain, lpszTitle);

			}

			dwVSizeW = bmBMP.getWidth();
			dwVSizeH = bmBMP.getHeight();
			MoveWindow(hwBMP, 0, BMP_WND_YPOS, dwVWidth - 1, dwVHeight, FALSE);
			MoveWindow(hwBMP, 0, BMP_WND_YPOS, dwVWidth, dwVHeight, TRUE);

			InvalidateRgn(hwnd, NULL, FALSE);

			break;

		case IDM_SAVE: // ۑj[

			// _CAOݒ
			ofn.lpstrTitle = lpszSave;
			ofn.Flags = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;

			if (!GetSaveFileName(&ofn)) { // t@CI
				return 0;
			}

			// gq⊮
			if (ofn.nFilterIndex == 1 && stricmp(lpszFn + (strlen(lpszFn) - 4), ".bmp") != 0) {
				lstrcat(lpszFn, ".bmp");
			}

			if (bmBMP.saveImage(lpszFn)) { // t@Cɕۑ

				fSave=false;

				lstrcpy(lpszFileName, lpszFn);
				wsprintf(lpszTitle, "%s - %s",lpszAppName, lpszFileName);
				SetWindowText(hwMain, lpszTitle);

			}

			break;

		case IDM_WRITE: // ㏑ۑj[

			if (lpszFileName[0] != 0) {

				if (bmBMP.saveImage(lpszFileName)) {
					fSave = false;
				} else {
					MessageBox(hwnd, "ۑɎs܂B", "G[", MB_OK);
				}

				break;

			}

			// _CAOݒ
			ofn.lpstrTitle = lpszSave;
			ofn.Flags = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
			ofn.nFilterIndex = 1;

			if (!GetSaveFileName(&ofn)) { // t@CI
				return 0;
			}

			if (ofn.nFilterIndex == 1 && stricmp(lpszFn + (strlen(lpszFn) - 4), ".bmp") != 0) {
				lstrcat(lpszFn, ".bmp");
			}

			if (bmBMP.saveImage(lpszFn)) { // t@Cɕۑ

				fSave = FALSE;

				lstrcpy(lpszFileName, lpszFn);
				wsprintf(lpszTitle, "%s - %s", lpszAppName, lpszFileName);
				SetWindowText(hwMain, lpszTitle);

			}

			break;

		case IDM_EXIT: // Ij[

			DestroyWindow(hwMain);

			break;

		case IDM_COPY: // Rs[

			bmBMP.copy();

			break;

		case IDM_PASTE: // \t

			if (bmBMP.paste()) {

				lpszFileName[0] = 0;
				wsprintf(lpszTitle, "%s - %s", lpszAppName, lpszFileName);
				SetWindowText(hwMain, lpszTitle);

			}

			dwVSizeW = bmBMP.getWidth();
			dwVSizeH = bmBMP.getHeight();
			MoveWindow(hwBMP, 0, BMP_WND_YPOS, dwVWidth - 1, dwVHeight, FALSE);
			MoveWindow(hwBMP, 0, BMP_WND_YPOS, dwVWidth, dwVHeight, TRUE);

			InvalidateRgn(hwnd, NULL, FALSE);

			break;

		case IDM_ALL: // S̏

			// RGBύX
			for (i = 0;i < bmBMP.getHeight();i++)
				for (j = 0;j < bmBMP.getWidth();j++)
					bmBMP.addRGB(j, i, iDR, iDG, iDB);

			InvalidateRgn(hwBMP, NULL, FALSE);

			break;

		case IDM_SIZE: // 摜TCY

			wsprintf(aszTmp, "F%dsNZ@F%dsNZ", bmBMP.getWidth(), bmBMP.getHeight());

			MessageBox(hwnd, aszTmp, "摜TCY", MB_OK);

			break;

		case IDM_ABOUT: // o[W

			MessageBox(hwnd, "OfZ@ 05 (C)2003-2006 ˁ@P", "o[W", MB_OK);

			break;

		case IDM_JUMP: // nvO~O̊X

			ShellExecute(NULL, "open", "http://www.sm.rim.or.jp/~shishido/", 
			  NULL, NULL, SW_SHOWNORMAL);

			break;

		}
	
		return 0;

	case WM_SIZE: // EChETCYύX

		SendMessage(hwState, WM_SIZE, LOWORD(lParam), 0);

		GetWindowRect(hwState, &rec);

		dwVWidth = LOWORD(lParam);
		dwVHeight = HIWORD(lParam) - (rec.bottom - rec.top) - BMP_WND_YPOS;

		SetWindowPos(hwBMP, hwnd, 0, BMP_WND_YPOS, dwVWidth, dwVHeight, SWP_NOZORDER);

		return 0;

	case WM_DESTROY : // I

		PostQuitMessage(0);

		return 0;

	}

	return DefWindowProc(hwnd, iMsg, wParam, lParam) ;

}

// DIBEChEEChEvV[W[
LRESULT CALLBACK BMPWndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam) {

	static SCROLLINFO sInfo;
	static int iVSMin, iVSMax, iVSPage, iHSMin, iHSMax, iHSPage, iVSd, iVSPos, iHSd, iHSPos;
	int iPosX, iPosY, iR, iG, iB;
	HDC hdc;
	PAINTSTRUCT ps;
	char tmp[64];

	int i, j;

	switch (iMsg) {

	case WM_SIZE: // EChETCYύX

		sInfo.cbSize = sizeof(SCROLLINFO);
		sInfo.fMask = SIF_ALL;

		// XN[o[TCYݒ
		if (LOWORD(lParam) < (int)dwVSizeW) {

			iHSMin = 0;
			iHSMax = dwVSizeW;
			iHSPage = LOWORD(lParam);

		} else {

			iHSMin = 0;
			iHSMax = 0;
			iHSPage = 0;

		}

		// XN[o[ʒuݒ
		iHSPos = min(iHSPos, iHSMax - iHSPage);

		// SCROLLINFO\̐ݒ
		sInfo.nMin = iHSMin;
		sInfo.nMax = iHSMax;
		sInfo.nPage = iHSPage;

		// XN[o[ݒ
		SetScrollInfo(hwnd, SB_HORZ, &sInfo, TRUE);

		// XN[o[TCYݒ
		if (HIWORD(lParam) < (int)dwVSizeH) {

			iVSMin = 0;
			iVSMax = dwVSizeH;
			iVSPage = HIWORD(lParam);

		} else {

			iVSMin = 0;
			iVSMax = 0;
			iVSPage = 0;

		}

		// XN[o[ʒuݒ
		iVSPos = min(iVSPos, iVSMax - iVSPage);

		// SCROLLINFO\̐ݒ
		sInfo.nMin = iVSMin;
		sInfo.nMax = iVSMax;
		sInfo.nPage = iVSPage;
		sInfo.nPos = iVSPos;

		// XN[o[ݒ
		SetScrollInfo(hwnd, SB_VERT, &sInfo, TRUE);

		// EChEĕ`
		InvalidateRgn(hwnd, NULL, FALSE);
		UpdateWindow(hwnd);

		return 0;

	case WM_HSCROLL: // XN[o[bZ[W

		switch(LOWORD(wParam)) {

		case SB_LINEUP:

			iHSd = -1;

			break;

		case SB_LINEDOWN:

			iHSd = 1;

			break;

		case SB_PAGEUP:
	
			iHSd = -iHSPage;

			break;

		case SB_PAGEDOWN:

			iHSd = iHSPage;

			break;

		case SB_THUMBTRACK:
					
			iHSd = HIWORD(wParam) - iHSPos;
					
			break;

		default:

			iHSd = 0;

		}

		if (iHSd != 0) {

			iHSPos += iHSd;

			iHSPos=max(iHSPos, 0);
			iHSPos=min(iHSPos, iHSMax - iHSPage);

			SetScrollPos(hwnd, SB_HORZ, iHSPos, TRUE);
			InvalidateRgn(hwnd, NULL, FALSE);
			UpdateWindow(hwnd);

		}

		return 0;

	case WM_VSCROLL: // XN[o[bZ[W

		switch(LOWORD(wParam)) {

		case SB_LINEUP:

			iVSd = -1;

			break;

		case SB_LINEDOWN:

			iVSd = 1;

			break;

		case SB_PAGEUP:
	
			iVSd = -iVSPage;

			break;

		case SB_PAGEDOWN:
	
			iVSd = iVSPage;

			break;

		case SB_THUMBTRACK:
					
			iVSd = HIWORD(wParam) - iVSPos;
					
			break;

		default:

			iVSd = 0;

		}

		if (iVSd != 0) {

			iVSPos += iVSd;

			iVSPos=max(iVSPos, 0);
			iVSPos=min(iVSPos, iVSMax - iVSPage);

			SetScrollPos(hwnd, SB_VERT, iVSPos, TRUE);

			InvalidateRgn(hwnd, NULL, FALSE);
			UpdateWindow(hwnd);

		}

		return 0;

	case WM_LBUTTONDOWN: // {^

		// }EXJ[\W擾
		iPosX = LOWORD(lParam) + iHSPos;
		iPosY = HIWORD(lParam) + iVSPos;

		int iSX, iSY;

		// RGBύẌ̍WZo
		iSX = iPosX - (int)(floor(iSize / 2));
		iSY = iPosY - (int)(floor(iSize / 2));

		// RGBύX
		for (i = 0;i < iSize;i++)
			for (j = 0;j < iSize;j++)
				bmBMP.addRGB(iSX + j, iSY + i, iDR, iDG, iDB);

		InvalidateRgn(hwnd, NULL, FALSE);

		iR = bmBMP.getR(iPosX, iPosY);
		iG = bmBMP.getG(iPosX, iPosY);
		iB = bmBMP.getB(iPosX, iPosY);

		wsprintf(tmp, "(%d,%d)-R:%d,G:%d,B:%d", iPosX, iPosY, iR, iG, iB);
		SendMessage(hwState, SB_SETTEXT, 0, (long)tmp);

		fSave = true;

		return 0;

	case WM_MOUSEMOVE: // }EXJ[\ړ

		// }EXJ[\W擾
		iPosX = LOWORD(lParam) + iHSPos;
		iPosY = HIWORD(lParam) + iVSPos;

		if (iPosX<0 || iPosX >= bmBMP.getWidth() || iPosY >= bmBMP.getHeight() || iPosY<0) {
			return 0;
		}

		if (GetAsyncKeyState(VK_LBUTTON) < 0) { // {^ĂARGBύX

			int iSX, iSY;

			iSX = iPosX - (int)(floor(iSize / 2));
			iSY = iPosY - (int)(floor(iSize / 2));

			for (i = 0;i < iSize;i++)
				for (j = 0;j < iSize;j++)
					bmBMP.addRGB(iSX + j, iSY + i, iDR, iDG, iDB);

			InvalidateRgn(hwnd, NULL, FALSE);
			UpdateWindow(hwnd);

			fSave = true;

		}

		iR = bmBMP.getR(iPosX, iPosY);
		iG = bmBMP.getG(iPosX, iPosY);
		iB = bmBMP.getB(iPosX, iPosY);

		wsprintf(tmp, "(%d,%d)-R:%d,G:%d,B:%d", iPosX, iPosY, iR, iG, iB);

		SendMessage(hwState, SB_SETTEXT, 0, (long)tmp);

		return 0;

	case WM_PAINT:

		hdc = BeginPaint(hwnd, &ps);

		/* rbg}bvʂɕ` */
	    StretchDIBits(hdc, -iHSPos, -iVSPos, bmBMP.getWidth(), bmBMP.getHeight(),
		   0, 0, bmBMP.getWidth(), bmBMP.getHeight(),
		   bmBMP.getPixels(), bmBMP.getInfo(), DIB_RGB_COLORS, SRCCOPY);

		EndPaint(hwnd, &ps);

		return 0;

	case WM_DESTROY:

		return 0;

	}

	return DefWindowProc(hwnd, iMsg, wParam, lParam);

}
