#pragma once
#include <windows.h>

class CBitmap32 {

public:

	CBitmap32();
	CBitmap32(int iWidth, int iHeight);
	CBitmap32(LPCTSTR lpszFilePath);

	bool assign(const CBitmap32 *pbmArg);

	CBitmap32& operator=(const CBitmap32&);

	bool loadImage(LPCTSTR lpszFilePath);
	bool loadImage(const LPVOID lpImage);

	bool saveImage(LPCTSTR lpszFilePath);

	bool paste();
	bool copy();

	CBitmap32 * subImage(int iX, int iY, int iWidth, int iHeight) const;

	int getWidth() const;
	int getHeight() const;

	BYTE getR(int iX, int iY) const;
	BYTE getG(int iX, int iY) const;
	BYTE getB(int iX, int iY) const;

	DWORD getRGB(int iX, int iY) const;
	DWORD getPixel(int iX, int iY) const;

	bool setR(int iX, int iY, int iValue);
	bool setG(int iX, int iY, int iValue);
	bool setB(int iX, int iY, int iValue);
	bool setRGB(int iX, int iY, DWORD dwValue);
	bool setPixel(int iX, int iY, DWORD dwValue);

	bool addRGB(int iX, int iY, int iDR, int iDG, int iDB);

	LPBITMAPINFO getInfo() const;
	LPVOID getPixels() const;

	~CBitmap32();

private:

	LPVOID m_lpBuf;
	LPBITMAPINFOHEADER m_lpbmiInfo;
	LPDWORD m_lpPixels;

	int m_iWidth, m_iHeight;

	bool init(int iWidth, int iHeight);

};
